/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.object.EasingType;
import software.bernie.geckolib.animation.state.AnimationPoint;
import software.bernie.geckolib.animation.state.BoneSnapshot;
import software.bernie.geckolib.animation.state.ControllerState;
import software.bernie.geckolib.animation.state.EasingState;
import software.bernie.geckolib.cache.animation.Animation;
import software.bernie.geckolib.cache.animation.BoneAnimation;
import software.bernie.geckolib.cache.animation.Keyframe;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.loading.math.MathValue;
import software.bernie.geckolib.loading.math.MolangQueries;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.BoneSnapshots;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.util.ClientUtil;

@ApiStatus.Internal
public class AnimationProcessor {
    public static <T extends GeoAnimatable> void extractControllerStates(T animatable, GeoRenderState renderState, GeoModel<T> geoModel) {
        AnimatableManager manager = Objects.requireNonNull(renderState.getGeckolibData(DataTickets.ANIMATABLE_MANAGER));
        Collection controllers = manager.getAnimationControllers().values();
        double tick = renderState.getAnimatableAge();
        ObjectArrayList controllerStates = new ObjectArrayList(controllers.size());
        manager.markRenderedAt(tick);
        if (!controllers.isEmpty()) {
            float partialTick = renderState.getPartialTick();
            class_1937 level = ClientUtil.getLevel();
            class_1657 player = ClientUtil.getClientPlayer();
            class_243 cameraPos = ClientUtil.getCameraPos();
            double renderTime = manager.getFirstRenderTick() - tick;
            if (level != null && player != null) {
                for (AnimationController<T> controller : controllers) {
                    MolangQueries.Actor<T> actor;
                    ControllerState controllerState = controller.extractControllerState(animatable, renderState, manager, actor = new MolangQueries.Actor<T>(animatable, renderState, controller, renderTime, partialTick, level, player, cameraPos), geoModel);
                    if (controllerState == null) continue;
                    controllerStates.add(controllerState);
                }
            }
        }
        renderState.addGeckolibData(DataTickets.ANIMATION_CONTROLLER_STATES, controllerStates.toArray(new ControllerState[0]));
    }

    public static void createBoneSnapshots(ControllerState controllerState, BoneSnapshots snapshots) {
        AnimationPoint animation = controllerState.animationPoint();
        AnimationPoint prevAnimation = controllerState.prevAnimationPoint();
        EasingType easingOverride = controllerState.easingOverride();
        boolean additive = controllerState.additive();
        BoneAnimation[] boneAnimations = animation.animation().boneAnimations();
        for (int boneIndex = 0; boneIndex < boneAnimations.length; ++boneIndex) {
            BoneSnapshot snapshot = snapshots.get(boneAnimations[boneIndex].boneName()).orElse(null);
            if (snapshot == null) continue;
            AnimationProcessor.setSnapshotScale(snapshot, boneIndex, controllerState, additive, animation, prevAnimation, easingOverride);
            AnimationProcessor.setSnapshotRotation(snapshot, boneIndex, controllerState, additive, animation, prevAnimation, easingOverride);
            AnimationProcessor.setSnapshotTranslation(snapshot, boneIndex, controllerState, additive, animation, prevAnimation, easingOverride);
        }
    }

    private static void setSnapshotScale(BoneSnapshot snapshot, int boneIndex, ControllerState controllerState, boolean additive, AnimationPoint animation, @Nullable AnimationPoint prevAnimation, @Nullable EasingType easingOverride) {
        float xScale = AnimationProcessor.findAnimationPointValue(snapshot, controllerState, animation, prevAnimation, boneIndex, AnimationPoint.Transform.SCALE, AnimationPoint.Axis.X, easingOverride);
        float yScale = AnimationProcessor.findAnimationPointValue(snapshot, controllerState, animation, prevAnimation, boneIndex, AnimationPoint.Transform.SCALE, AnimationPoint.Axis.Y, easingOverride);
        float zScale = AnimationProcessor.findAnimationPointValue(snapshot, controllerState, animation, prevAnimation, boneIndex, AnimationPoint.Transform.SCALE, AnimationPoint.Axis.Z, easingOverride);
        if (additive) {
            xScale *= snapshot.getScaleX();
            yScale *= snapshot.getScaleY();
            zScale *= snapshot.getScaleZ();
        }
        snapshot.setScale(xScale, yScale, zScale);
    }

    private static void setSnapshotRotation(BoneSnapshot snapshot, int boneIndex, ControllerState controllerState, boolean additive, AnimationPoint animation, @Nullable AnimationPoint prevAnimation, @Nullable EasingType easingOverride) {
        float xRot = AnimationProcessor.findAnimationPointValue(snapshot, controllerState, animation, prevAnimation, boneIndex, AnimationPoint.Transform.ROTATION, AnimationPoint.Axis.X, easingOverride);
        float yRot = AnimationProcessor.findAnimationPointValue(snapshot, controllerState, animation, prevAnimation, boneIndex, AnimationPoint.Transform.ROTATION, AnimationPoint.Axis.Y, easingOverride);
        float zRot = AnimationProcessor.findAnimationPointValue(snapshot, controllerState, animation, prevAnimation, boneIndex, AnimationPoint.Transform.ROTATION, AnimationPoint.Axis.Z, easingOverride);
        if (additive) {
            GeoBone bone = snapshot.getBone();
            xRot += snapshot.getRotX() - bone.baseRotX();
            yRot += snapshot.getRotY() - bone.baseRotY();
            zRot += snapshot.getRotZ() - bone.baseRotZ();
        }
        snapshot.setRotation(xRot, yRot, zRot);
    }

    private static void setSnapshotTranslation(BoneSnapshot snapshot, int boneIndex, ControllerState controllerState, boolean additive, AnimationPoint animation, @Nullable AnimationPoint prevAnimation, @Nullable EasingType easingOverride) {
        float xPos = AnimationProcessor.findAnimationPointValue(snapshot, controllerState, animation, prevAnimation, boneIndex, AnimationPoint.Transform.TRANSLATION, AnimationPoint.Axis.X, easingOverride);
        float yPos = AnimationProcessor.findAnimationPointValue(snapshot, controllerState, animation, prevAnimation, boneIndex, AnimationPoint.Transform.TRANSLATION, AnimationPoint.Axis.Y, easingOverride);
        float zPos = AnimationProcessor.findAnimationPointValue(snapshot, controllerState, animation, prevAnimation, boneIndex, AnimationPoint.Transform.TRANSLATION, AnimationPoint.Axis.Z, easingOverride);
        if (additive) {
            xPos += snapshot.getTranslateX();
            yPos += snapshot.getTranslateY();
            zPos += snapshot.getTranslateZ();
        }
        snapshot.setTranslation(xPos, yPos, zPos);
    }

    public static float findAnimationPointValue(BoneSnapshot boneSnapshot, ControllerState controllerState, AnimationPoint animation, @Nullable AnimationPoint prevAnimation, int boneIndex, AnimationPoint.Transform transform, AnimationPoint.Axis axis, @Nullable EasingType easingOverride) {
        Keyframe toKeyframe;
        if (controllerState.transitionTime() >= 0.0) {
            return prevAnimation != null ? AnimationProcessor.findTransitionPointValue(boneSnapshot, controllerState, animation, prevAnimation, boneIndex, transform, axis, easingOverride) : AnimationProcessor.findResetPointValue(boneSnapshot, controllerState, animation, boneIndex, transform, axis, easingOverride);
        }
        Keyframe fromKeyframe = animation.getCurrentKeyframe(boneIndex, transform, axis);
        if (fromKeyframe == null || (toKeyframe = animation.getNextKeyframe(boneIndex, transform, axis)) == null) {
            return transform.defaultValue;
        }
        double from = fromKeyframe.endValue().get(controllerState);
        double to = toKeyframe.endValue().get(controllerState);
        double delta = (animation.animTime() - fromKeyframe.startTime()) / toKeyframe.length();
        EasingState easingState = new EasingState(easingOverride != null ? easingOverride : toKeyframe.easingType(), toKeyframe.easingArgs(), delta, from, to);
        return (float)EasingType.lerpWithOverride(easingState, controllerState);
    }

    private static float findTransitionPointValue(BoneSnapshot boneSnapshot, ControllerState controllerState, AnimationPoint animation, AnimationPoint prevAnimation, int boneIndex, AnimationPoint.Transform transform, AnimationPoint.Axis axis, @Nullable EasingType easingOverride) {
        int prevBoneIndex;
        Keyframe toKeyframe = animation.getNextKeyframe(boneIndex, transform, axis);
        if (toKeyframe == null || (prevBoneIndex = prevAnimation.findBoneIndex(boneSnapshot.getBone())) < 0) {
            return transform.defaultValue;
        }
        double from = AnimationProcessor.wrapRotation(AnimationProcessor.findAnimationPointValue(boneSnapshot, controllerState, prevAnimation, null, prevBoneIndex, transform, axis, prevAnimation.easingOverride()), transform);
        double to = toKeyframe.startValue().get(controllerState);
        double delta = Math.min(1.0, controllerState.transitionTime() / (double)controllerState.transitionTicks());
        EasingState easingState = new EasingState(easingOverride != null ? easingOverride : toKeyframe.easingType(), toKeyframe.easingArgs(), delta, from, to);
        return (float)EasingType.lerpWithOverride(easingState, controllerState);
    }

    private static float findResetPointValue(BoneSnapshot boneSnapshot, ControllerState controllerState, AnimationPoint animation, int boneIndex, AnimationPoint.Transform transform, AnimationPoint.Axis axis, @Nullable EasingType easingOverride) {
        ControllerState previousState = new ControllerState(controllerState.animationPoint(), null, -1.0, 0, controllerState.additive(), controllerState.easingOverride(), controllerState.renderState(), controllerState.queryValues());
        double delta = Math.min(1.0, controllerState.transitionTime() / (double)controllerState.transitionTicks());
        double from = AnimationProcessor.wrapRotation(AnimationProcessor.findAnimationPointValue(boneSnapshot, previousState, animation, null, boneIndex, transform, axis, easingOverride), transform);
        double to = AnimationProcessor.getSnapshotResetTarget(boneSnapshot, transform, axis, controllerState.additive());
        EasingState easingState = new EasingState(easingOverride == null ? EasingType.LINEAR : easingOverride, new MathValue[0], delta, from, to);
        return (float)EasingType.lerpWithOverride(easingState, controllerState);
    }

    private static float getSnapshotResetTarget(BoneSnapshot snapshot, AnimationPoint.Transform transform, AnimationPoint.Axis axis, boolean additive) {
        if (!additive) {
            return transform.defaultValue;
        }
        return switch (transform) {
            default -> throw new MatchException(null, null);
            case AnimationPoint.Transform.SCALE -> {
                switch (axis) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case X: {
                        yield snapshot.getScaleX();
                    }
                    case Y: {
                        yield snapshot.getScaleY();
                    }
                    case Z: 
                }
                yield snapshot.getScaleZ();
            }
            case AnimationPoint.Transform.ROTATION -> {
                switch (axis) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case X: {
                        yield snapshot.getRotX();
                    }
                    case Y: {
                        yield snapshot.getRotY();
                    }
                    case Z: 
                }
                yield snapshot.getRotZ();
            }
            case AnimationPoint.Transform.TRANSLATION -> {
                switch (axis) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case X: {
                        yield snapshot.getTranslateX();
                    }
                    case Y: {
                        yield snapshot.getTranslateY();
                    }
                    case Z: 
                }
                yield snapshot.getTranslateZ();
            }
        };
    }

    private static double wrapRotation(double value, AnimationPoint.Transform transform) {
        if (transform != AnimationPoint.Transform.ROTATION) {
            return value;
        }
        return class_3532.method_15338((double)(value * 57.2957763671875)) * 0.01745329238474369;
    }

    public static <T extends GeoAnimatable> @Nullable Animation getOrCreateAnimation(RawAnimation.Stage stage, T animatable, GeoModel<T> geoModel) {
        if (stage.animationName() == "internal.wait") {
            return Animation.generateWaitAnimation(stage.waitTicks());
        }
        return geoModel.getBakedAnimation(animatable, stage.animationName());
    }
}

